#include <Wire.h>

#define EEPROM2 0x50

unsigned int addr=0;
byte zeichen;

void setup() 
{
  Serial.begin(9600);
  Wire.begin();
  delay(100);
}

void loop() 
{
  while(Serial.available()==0); // Warte auf eingehende Zeichen
  zeichen=Serial.read();
  eeprom_write(EEPROM2,addr,zeichen);
  addr++;
}

void eeprom_write(byte i2c, unsigned int adresse, byte data)
{
  Wire.beginTransmission(i2c);
  Wire.write((unsigned int)(adresse >> 8));
  Wire.write((unsigned int)(adresse & 0xFF));
  Wire.write(data);
  Wire.endTransmission();
  delay(5); // Schreiben benötigt Zeit
}
